package bropen

import java.util.Map;

import javax.jws.WebParam
import javax.jws.WebMethod
import javax.jws.WebService
import javax.jws.WebResult

import org.apache.cxf.annotations.WSDLDocumentation
import org.apache.cxf.annotations.WSDLDocumentationCollection
import javax.xml.bind.annotation.XmlAccessorType
import javax.xml.bind.annotation.XmlAccessType
import javax.xml.bind.annotation.XmlElement

import org.grails.cxf.utils.GrailsCxfEndpoint
import org.grails.cxf.utils.GrailsCxfEndpointProperty
import org.grails.cxf.utils.EndpointType

//import javax.xml.ws.Holder;
import javax.xml.ws.soap.MTOM
import javax.xml.bind.annotation.XmlMimeType
import javax.activation.DataHandler
import javax.activation.FileDataSource

@WebService(targetNamespace = 'http://test.services.bropen.com.cn/')
@GrailsCxfEndpoint( expose = EndpointType.JAX_WS )
@WSDLDocumentationCollection([
	@WSDLDocumentation(value = "WSDL定义说明111",
	placement = WSDLDocumentation.Placement.TOP),
	@WSDLDocumentation("Endpoint说明222")
])
@MTOM(enabled = true)
class JaxWsEndpoint {

	/** 不自动注册为WS方法 */
	@WebMethod(exclude = true)
	String excludedMethod() {
		//...
	}

	@WebResult(name = 'result')
	@WebMethod(operationName = 'testDate')
	@WSDLDocumentation("日期类型测试")
	Date testDate( @WebParam(name = 'date') Date date ) {
		return date
	}
	
	@WebResult(name = 'result')
	@WebMethod(operationName = 'testUpload')
	@WSDLDocumentation("上传附件")
	Result testUpload(
			@WebParam(name = 'fileName')
			String fileName,
			@XmlMimeType("*/*")
			@WebParam(name="fileDataHandler")
			DataHandler fileDataHandler ) {
		Result result = new Result();
		InputStream is = null;
		OutputStream os = null;
		try {
			is = fileDataHandler.getInputStream();
			os = new FileOutputStream( System.getProperty("java.io.tmpdir") + File.separator + fileName );
			byte[] buf = new byte[1024*1024];
			int read;
			while( (read = is.read(buf)) != -1 ) {
				os.write(buf, 0, read);
				os.flush();
			}
		} catch ( Exception e ) {
			result.success = Boolean.FALSE;
			result.message = e.getMessage();
			log.error(null, e);
		} finally {
			is?.close();
			os?.close();
		}
		return result;
	}

	@WebResult
	@WebMethod(operationName = 'testDownload')
	@XmlMimeType("*/*")
	@WSDLDocumentation("下载附件")
	DataHandler testDownload( @WebParam(name="fileName") String fileName )
			throws FileNotFoundException, SecurityException {
		File file = new File( System.getProperty("java.io.tmpdir") + File.separator + fileName );
		if ( !file.exists() ) {
			throw new FileNotFoundException("File [" + fileName + "] not found!");
		} else if ( !file.canRead() ) {
			throw new SecurityException("Cannot read file [" + fileName + "]!");
		}
		return new DataHandler(
			new FileDataSource(file){
				public String getContentType() {
					return new javax.activation.MimetypesFileTypeMap().getContentType(fileName);
				}
			}
		);
	}

	@WebResult(name = 'result')
	@WebMethod(operationName = 'testMethod')
	@WSDLDocumentation("WS方法说明3333")
	Result testMethod( @WebParam(name = 's') String s ) {
		Result r = new Result();
		r.success = Boolean.FALSE;
		r.message = "莫须有！"
		return r;
	}

	@WebResult(name = 'result')
	@WebMethod(operationName = 'testMap')
	@WSDLDocumentation("Map类型的数据交换")
	Map<String, String> testMap(Map<String, String> p) {
		return p
	}

	// 定义几个内部的静态类

	/** 操作结果 */
	@XmlAccessorType(XmlAccessType.NONE)
	static class Result {
		/** 操作是否成功 */
		@XmlElement(nillable=false, required=true)
		Boolean success = Boolean.TRUE;

		/** 成功或失败的消息 */
		@XmlElement(nillable=true, required=false)
		String message
	}

}
